<?php
/* --------------------------------------------------------------
   GambioHubPayPalConfigurationStorage.inc.php 2020-05-08
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

class GambioHubPayPalConfigurationStorage extends GambioHubPayPalConfigurationStorage_parent
{
    public function get($key)
    {
        if(strtolower((string)@constant('MODULE_PAYMENT_GAMBIO_HUB_STATUS')) !== 'true') {
            return parent::get($key);
        }
        
        $hubPayPalConfiguration = MainFactory::create('HubPayPalConfiguration');
        
        if ($hubPayPalConfiguration->isInstallmentsActive() &&
            in_array(
                $key,
                [
                    'show_installments_presentment_specific_product',
                    'show_installments_presentment_specific_cart',
                    'show_installments_presentment_specific_computed',
                ]
            )
        ) {
            if($key === 'show_installments_presentment_specific_product') {
                return $hubPayPalConfiguration->isIUPSpecificProduct();
            }
            if($key === 'show_installments_presentment_specific_cart') {
                return $hubPayPalConfiguration->isIUPSpecificCart();
            }
            if($key === 'show_installments_presentment_specific_computed') {
                return $hubPayPalConfiguration->isIUPSpecificComputed();
            }
        }
        
        return parent::get($key);
    }
}
